
# Defining canvas size, line thickness, and font size
set terminal pngcairo size 900,700 enhanced lw 3 fontscale 2.0

# Setting filname of the output
set output "example_gnuplot_output.png"

# Formatting plot (axis titles, range, tickmarks)
set yrange [-5:105]
set xlabel "t, s"
set ylabel "v, km/h" # Data in m/s! Need to scale by 3.6!
set xtics 1
set ytics 20
set grid

# Cycle for plotting all three datafiles on single canvas
plot for [i=1:3] \
	'breaking_speed_data_'.i.'.dat' using ($1):($2*3.6) with line title 'File '.i
