# -*- coding: utf-8 -*-
"""
Created on Sat Jan  2 09:37:50 2021

@author: Kristaps Bergfelds
"""



# Importing necesarry packages
# Nepieciešamie Python rīki (paketes)
import numpy as np
import matplotlib.pyplot as plt
import glob
from scipy.integrate import cumtrapz


# Reading all filenames ending with '.dat' from the current folder
# Ielasa visus faila nosaukumus no darba mapes, kas beidzas ar '.dat'.
text_filenames = glob.glob("*.dat")


# Defining canvas size for plotting
# Nosaka grafika zīmēšanas rakstlaukuma izmēru
plt.figure(figsize = (4.5,3.5), dpi = 200)


# Cycle through all filenames for data processing and plotting
# Katram no .dat failiem veiks datu apstrādi, iezīmēs grafikā
for filename in text_filenames:

    # Reading each file (tab-delimited data)
    # Ielasa katru failu (tabulatora atdalīti dati)
    time, velocity = np.loadtxt(
        filename,
        delimiter = "\t",
        skiprows = 1,
        unpack = True
        )
    
    # Using numerical integration to get distance from velocity data
    # Skaitliskā integrēšana, lai iegūtu attālumu no ātruma datiem
    distance = cumtrapz(velocity, time, initial=0.0)
    
    # Determining maximum velocity and distance (for later use in legend)
    # Nosaka maksimālo ātrumu un attālumu (lai lietotu grafika leģendā)
    velocity_max = velocity.max()
    distance_max = distance.max()
    
    # Plotting distance vs. time and putting the max distance in the legend
    # Grafikā iezīmē attālumu no laika, leģendā ieraksta bremzēšanas ceļu
    plt.plot(
        time,
        distance,
        label = "{:.0f} km/h - breaking dist. is {:.1f} m".format(
            velocity_max*3.6,
            distance_max
            )
        )


# Formatting of the plot (added grid, axis titles, legend)
# Noformē grafiku (pievieno režģi, asu nosaukumus, leģendu)
plt.grid()
plt.legend(loc="upper left")
plt.xlabel("t, s")
plt.ylabel("d, m")
plt.xlim(0,5)

# Saving the plot as PNG image
# Saglabā grafiku kā PNG attēlu
plt.savefig("example_python_output.png")